struct Dog {
    name: String,
    noise: String,
}

struct Cat {
    noise: String,
}

trait Animal {
    fn make_noise(&self);
}

impl Animal for Dog {
    fn make_noise(&self) {
        println!("{} is making {}", self.name, self.noise)
    }
}

impl Animal for Cat {
    fn make_noise(&self) {
        println!("{}", self.noise)
    }
}

fn main() {
    let animals: Vec<Box<dyn Animal>> = vec![
        Box::new(Dog {
            name: "Schnuffi".to_owned(),
            noise: "wuff".to_owned(),
        }),
        Box::new(Cat {
            noise: "miau".to_owned(),
        }),
    ];

    for animal in animals.iter() {
        animal.make_noise();
    }
}
