import random
import timeit
from rs_montecarlo import montecarlo


def my_montecarlo(samples: int) -> float:
    hits = 0

    for _ in range(samples):
        x = random.uniform(0, 1)
        y = random.uniform(0, 1)

        dist = x**2 + y**2

        if dist <= 1:
            hits += 1

    return hits / samples * 4


SAMPLES = 1_000_000
python_time = timeit.timeit(lambda: my_montecarlo(SAMPLES), number=10)
rust_time = timeit.timeit(lambda: montecarlo(SAMPLES), number=10)

print(f"{rust_time = }")
print(f"{python_time = }")
print(f"Rust version is: {round(python_time / rust_time, 2)} times faster")
